// File_Riff - Info for RIFF files
// Copyright (C) 2002-2006 Jerome Martinez, Zen@MediaArea.net
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Lesser General Public
// License as published by the Free Software Foundation; either
// version 2.1 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
//
// Information about RIFF files
//
//+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

//---------------------------------------------------------------------------
#ifndef MediaInfo_File_RiffH
#define MediaInfo_File_RiffH
//---------------------------------------------------------------------------

//---------------------------------------------------------------------------
#include "MediaInfo/File__Base.h"
//---------------------------------------------------------------------------

namespace MediaInfoLib
{

//***************************************************************************
// Class File_Riff
//***************************************************************************

class File_Riff : public File__Base
{
protected :
    //Formats
    int Read  (const int8u* Begin, size_t Begin_Size, const int8u* End=NULL, size_t End_Size=0, int64u FileSize=0);

    //Information
    void HowTo (stream_t StreamKind);

private :
    const int8u* Begin;
    size_t Begin_Size;
    const int8u* End;
    size_t End_Size;
    size_t Offset;
	bool ShouldStop;
    size_t Level;
    size_t Element_Offset[10];
    size_t Element_Size  [10];
    int32u Element_List  [10]; //4CC of the list type
    int32u TotalFrame; //Count of frame in all AVI file (with odml too)

    void Wave();
    void StreamHeader();
};

} //NameSpace

#endif
